/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_ipeek.c,v 1.32 2006/08/30 04:34:02 bgoglin Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__lib.h"
#include "mx__request.h"
#include "mx__error.h"
#include "mx__endpoint.h"

int
mx__ipeek_common(mx_endpoint_t endpoint, uint64_t match_info, uint64_t match_mask,
		 mx_request_t *request);

MX_FUNC(mx_return_t)
mx_ipeek(mx_endpoint_t endpoint, mx_request_t *request,
	 uint32_t *result)
{
  /* TODO: Make sure endpoint is valid? */

  if (endpoint->ctxid_bits)
    return mx__error(endpoint, "mx_ipeek", MX_NOT_SUPPORTED_WITH_CONTEXT_ID);

  MX__MUTEX_LOCK(&endpoint->lock);
  MX__EP_STATS_INC(endpoint, test);
  mx__luigi(endpoint);

  *result = mx__ipeek_common(endpoint, 0, 0, request);
  if (!*result)
    MX__EP_STATS_INC(endpoint, noncompleted_test);
  MX__MUTEX_UNLOCK(&endpoint->lock);
  return MX_SUCCESS;
}

int mx__ipeek_common(mx_endpoint_t endpoint, uint64_t match_info, uint64_t match_mask,
		     mx_request_t *request)
{
  union mx_request *r;
  uint32_t ctxid = CTXID_FROM_MATCHING(endpoint, match_info);

  r = mx__find_request_by_matching(&endpoint->ctxid[ctxid].doneq, match_info, match_mask);
  if (r) {
    *request = (mx_request_t)r;
    return 1;
  }
  else {
    if (mx__opt.zombie_send && endpoint->dead_count <= MX__MAX_DEAD) {
      struct mx__request_queue_head * elt;
      MX__FOREACH_REQ(r, elt, &endpoint->resend_list) {
	if ((r->basic.state & MX__REQUEST_STATE_BUFFERED)
	    && !(r->basic.state & MX__REQUEST_STATE_DEAD)
	    && !(r->basic.state & MX__REQUEST_STATE_INTERNAL)
#if MX_ONE_SIDED
	    && !(r->basic.status.match_info & MX__ONESIDED_MASK)
#endif
	   ) {
	  *request = r;
	  return 1;
	}
      }
    }
    *request = NULL;
    return 0;
  }
}
